/*
 This file is part of GNU Taler
 (C) 2021-2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { InternationalizationAPI } from "@gnu-taler/taler-util";
import { FormMetadata } from "./forms-types.js";
import { acceptTos } from "./gana/accept-tos.js";
import { form_challenger_email } from "./gana/challenger_email.js";
import { form_challenger_postal } from "./gana/challenger_postal.js";
import { form_challenger_sms } from "./gana/challenger_sms.js";
import { form_generic_note } from "./gana/generic_note.js";
import { form_gls_merchant_onboarding } from "./gana/gls_merchant_onboarding.js";
import { form_gls_wallet_confirmation } from "./gana/gls_wallet_confirmation.js";
import { form_multi_upload } from "./gana/multi_upload.js";
import { nameAndDob } from "./gana/nameAndBirthdate.js";
import { simplest } from "./gana/simplest.js";
import { form_vqf_902_11_customer } from "./gana/VQF_902_11_customer.js";
import { form_vqf_902_11_officer } from "./gana/VQF_902_11_officer.js";
import { form_vqf_902_14 } from "./gana/VQF_902_14.js";
import { form_vqf_902_1_customer } from "./gana/VQF_902_1_customer.js";
import { form_vqf_902_1_officer } from "./gana/VQF_902_1_officer.js";
import { form_vqf_902_4 } from "./gana/VQF_902_4.js";
import { form_vqf_902_5 } from "./gana/VQF_902_5.js";
import { form_vqf_902_9_customer } from "./gana/VQF_902_9_customer.js";
import { form_vqf_902_9_officer } from "./gana/VQF_902_9_officer.js";

export * from "./Calendar.js";
export * from "./Caption.js";
export * from "./Dialog.js";
export * from "./field-types.js";
export * from "./fields/InputAbsoluteTime.js";
export * from "./fields/InputAmount.js";
export * from "./fields/InputArray.js";
export * from "./fields/InputChoiceHorizontal.js";
export * from "./fields/InputChoiceStacked.js";
export * from "./fields/InputFile.js";
export * from "./fields/InputInteger.js";
export * from "./fields/InputLine.js";
export * from "./fields/InputSecret.js";
export * from "./fields/InputSelectMultiple.js";
export * from "./fields/InputSelectOne.js";
export * from "./fields/InputText.js";
export * from "./fields/InputTextArea.js";
export * from "./fields/InputToggle.js";
export * from "./FormProvider.js";
export * from "./forms-types.js";
export * from "./forms-ui.js";

export * from "./gana/accept-tos.js";
export * from "./gana/challenger_email.js";
export * from "./gana/challenger_postal.js";
export * from "./gana/challenger_sms.js";
export * from "./gana/generic_note.js";

export * from "./gana/gls_merchant_onboarding.js";
export * from "./gana/gls_wallet_confirmation.js";

export * from "./gana/VQF_902_11_customer.js";
export * from "./gana/VQF_902_11_officer.js";
export * from "./gana/VQF_902_14.js";
export * from "./gana/VQF_902_1_customer.js";
export * from "./gana/VQF_902_1_officer.js";
export * from "./gana/VQF_902_4.js";
export * from "./gana/VQF_902_5.js";
export * from "./gana/VQF_902_9_customer.js";
export * from "./gana/VQF_902_9_officer.js";

export * from "./Group.js";
export * from "./HtmlIframe.js";
export * from "./TimePicker.js";

export const preloadedForms: (
  i18n: InternationalizationAPI,
) => Array<FormMetadata> = (i18n) => [
  {
    label: i18n.str`Simple comment`,
    id: "__simple_comment",
    version: 1,
    config: simplest(i18n),
  },
  {
    label: i18n.str`Terms of Service`,
    id: "accept-tos",
    version: 1,
    config: (context: any) => acceptTos(i18n, context),
  },
  {
    label: i18n.str`Name and birthdate`,
    id: "name_and_dob",
    version: 1,
    config: nameAndDob(i18n),
  },
  form_vqf_902_1_customer(i18n),
  form_vqf_902_1_officer(i18n),
  form_vqf_902_4(i18n),
  form_vqf_902_5(i18n),
  form_vqf_902_11_customer(i18n),
  form_vqf_902_11_officer(i18n),
  form_vqf_902_14(i18n),
  form_vqf_902_9_customer(i18n),
  form_vqf_902_9_officer(i18n),
  form_generic_note(i18n),
  form_challenger_email(i18n),
  form_challenger_sms(i18n),
  form_challenger_postal(i18n),
  form_gls_merchant_onboarding(i18n),
  form_gls_wallet_confirmation(i18n),
  form_multi_upload(i18n),
  form_vqf_902_1_customer(i18n),
  form_vqf_902_1_officer(i18n),
  form_vqf_902_4(i18n),
  form_vqf_902_5(i18n),
  form_vqf_902_9_customer(i18n),
  form_vqf_902_9_officer(i18n),
  form_vqf_902_11_customer(i18n),
  form_vqf_902_11_officer(i18n),
  form_vqf_902_14(i18n),
  form_generic_note(i18n),
  form_gls_merchant_onboarding(i18n),
  form_gls_wallet_confirmation(i18n),
];
