/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero Public License for more details.

 You should have received a copy of the GNU Affero Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { TalerFormAttributes } from "@gnu-taler/taler-util";
import { format } from "date-fns";
import {
  countryNameList,
  DoubleColumnFormDesign,
  FormMetadata,
  InternationalizationAPI,
  SingleColumnFormDesign,
} from "../../index.browser.js";

export const form_challenger_postal = (
  i18n: InternationalizationAPI,
): FormMetadata => ({
  label: i18n.str`Challenger POSTAL`,
  description: i18n.str`Challenge address ownership.`,
  id: "challenger-postal",
  version: 0,
  config: design_challenger_postal(i18n),
});

/**
 * Design of the challenger email.
 */
export function design_challenger_postal(
  i18n: InternationalizationAPI,
): SingleColumnFormDesign {
  const today = format(new Date(), "yyyy-MM-dd");

  return {
    type: "single-column",
    fields: [
      {
        id: TalerFormAttributes.CONTACT_NAME,
        label: i18n.str`Name`,
        type: "text",
        required: true,
        disabled: true,
      },
      {
        id: TalerFormAttributes.ADDRESS_LINES,
        label: i18n.str`Address`,
        type: "textArea",
        required: true,
        disabled: true,
      },
      {
        id: TalerFormAttributes.ADDRESS_COUNTRY,
        label: i18n.str`Country`,
        type: "selectOne",
        choices: countryNameList(i18n),
        required: true,
        disabled: true,
      },
    ],
  };
}
